<?php
require 'includes/config.inc.php';

// Check if user is logged in
if (!isset($_SESSION['roll'])) {
    header("Location: index.php");
    exit();
}

// Handle form submission
$success_message = '';
$error_message = '';

if (isset($_POST['submit-complaint'])) {
    $student_id = $_SESSION['roll'];
    $category = mysqli_real_escape_string($conn, $_POST['category']);
    $subject = mysqli_real_escape_string($conn, $_POST['subject']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $priority = mysqli_real_escape_string($conn, $_POST['priority']);
    
    $sql = "INSERT INTO complaints (student_id, category, subject, description, priority) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_stmt_init($conn);
    
    if (mysqli_stmt_prepare($stmt, $sql)) {
        mysqli_stmt_bind_param($stmt, "sssss", $student_id, $category, $subject, $description, $priority);
        if (mysqli_stmt_execute($stmt)) {
            $success_message = "Complaint submitted successfully! Track it in 'My Complaints'.";
        } else {
            $error_message = "Error submitting complaint. Please try again.";
        }
    }
}

// Fetch user's complaints
$student_id = $_SESSION['roll'];
$complaints_sql = "SELECT * FROM complaints WHERE student_id = '$student_id' ORDER BY created_at DESC";
$complaints_result = mysqli_query($conn, $complaints_sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Submit Complaint - HMS</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="utf-8">
    <link rel="stylesheet" href="web_home/css_home/bootstrap.css">
    <link rel="stylesheet" href="web_home/css_home/style.css" type="text/css" media="all" />
    <link rel="stylesheet" href="web_home/css_home/fontawesome-all.css">
    <link href="//fonts.googleapis.com/css?family=Poiret+One&amp;subset=cyrillic,latin-ext" rel="stylesheet">
    <style>
        .complaint-form {
            background: rgba(255,255,255,0.95);
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            margin: 30px auto;
            max-width: 800px;
        }
        .form-control {
            border-radius: 10px;
            border: 2px solid #e0e0e0;
            padding: 12px 15px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #7c3aed;
            box-shadow: 0 0 10px rgba(124, 58, 237, 0.2);
        }
        .btn-submit {
            background: linear-gradient(135deg, #00d4ff 0%, #7c3aed 100%);
            border: none;
            padding: 12px 40px;
            border-radius: 25px;
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(124, 58, 237, 0.4);
            color: white;
        }
        .alert-success {
            background: linear-gradient(135deg, #00c853, #00e676);
            color: white;
            border: none;
            border-radius: 10px;
        }
        .alert-danger {
            background: linear-gradient(135deg, #ff5252, #ff1744);
            color: white;
            border: none;
            border-radius: 10px;
        }
        .complaint-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            border-left: 4px solid #7c3aed;
            transition: all 0.3s ease;
        }
        .complaint-card:hover {
            transform: translateX(5px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        }
        .status-pending { color: #ff9800; font-weight: 600; }
        .status-in_progress { color: #2196f3; font-weight: 600; }
        .status-resolved { color: #4caf50; font-weight: 600; }
        .status-rejected { color: #f44336; font-weight: 600; }
        .priority-low { background: #e8f5e9; color: #2e7d32; }
        .priority-medium { background: #fff3e0; color: #ef6c00; }
        .priority-high { background: #ffebee; color: #c62828; }
        .priority-urgent { background: #f44336; color: white; }
        .badge-priority {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            text-transform: uppercase;
        }
        .section-title {
            color: #1a1a2e;
            font-weight: 700;
            margin-bottom: 25px;
            padding-bottom: 10px;
            border-bottom: 3px solid #7c3aed;
            display: inline-block;
        }
    </style>
</head>
<body>
    <div class="banner" id="home">
        <div class="cd-radial-slider-wrapper">
            <header>
                <div class="container agile-banner_nav">
                    <nav class="navbar navbar-expand-lg navbar-light bg-light">
                        <h1><a class="navbar-brand" href="home.php">HMS <span class="display"></span></a></h1>
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse justify-content-center" id="navbarSupportedContent">
                            <ul class="navbar-nav ml-auto">
                                <li class="nav-item"><a class="nav-link" href="home.php">Home</a></li>
                                <li class="nav-item"><a class="nav-link" href="services.php">Hostels</a></li>
                                <li class="nav-item active"><a class="nav-link" href="submit_complaint.php">Complaints</a></li>
                                <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
                                <li class="dropdown nav-item">
                                    <a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown"><?php echo $_SESSION['roll']; ?></a>
                                    <ul class="dropdown-menu agile_short_dropdown">
                                        <li><a href="profile.php">My Profile</a></li>
                                        <li><a href="includes/logout.inc.php">Logout</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </header>
        </div>
    </div>

    <div class="container" style="padding-top: 30px;">
        <div class="row">
            <div class="col-md-6">
                <div class="complaint-form">
                    <h3 class="section-title"><i class="fas fa-edit"></i> Submit New Complaint</h3>
                    
                    <?php if ($success_message): ?>
                        <div class="alert alert-success"><?php echo $success_message; ?></div>
                    <?php endif; ?>
                    <?php if ($error_message): ?>
                        <div class="alert alert-danger"><?php echo $error_message; ?></div>
                    <?php endif; ?>
                    
                    <form method="POST" action="">
                        <div class="form-group">
                            <label><strong>Category</strong></label>
                            <select name="category" class="form-control" required>
                                <option value="">-- Select Category --</option>
                                <option value="Room Maintenance">Room Maintenance</option>
                                <option value="Electricity">Electricity Issue</option>
                                <option value="Plumbing">Plumbing</option>
                                <option value="Furniture">Furniture</option>
                                <option value="Cleanliness">Cleanliness</option>
                                <option value="Security">Security</option>
                                <option value="Mess/Food">Mess/Food</option>
                                <option value="Internet/WiFi">Internet/WiFi</option>
                                <option value="Roommate Issue">Roommate Issue</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label><strong>Priority</strong></label>
                            <select name="priority" class="form-control" required>
                                <option value="low">Low - Can wait</option>
                                <option value="medium" selected>Medium - Normal</option>
                                <option value="high">High - Important</option>
                                <option value="urgent">Urgent - Emergency</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label><strong>Subject</strong></label>
                            <input type="text" name="subject" class="form-control" placeholder="Brief subject of your complaint" required>
                        </div>
                        
                        <div class="form-group">
                            <label><strong>Description</strong></label>
                            <textarea name="description" class="form-control" rows="5" placeholder="Describe your complaint in detail..." required></textarea>
                        </div>
                        
                        <button type="submit" name="submit-complaint" class="btn btn-submit">
                            <i class="fas fa-paper-plane"></i> Submit Complaint
                        </button>
                    </form>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="complaint-form">
                    <h3 class="section-title"><i class="fas fa-list"></i> My Complaints</h3>
                    
                    <?php if (mysqli_num_rows($complaints_result) == 0): ?>
                        <p class="text-muted text-center">No complaints submitted yet.</p>
                    <?php else: ?>
                        <?php while ($complaint = mysqli_fetch_assoc($complaints_result)): ?>
                            <div class="complaint-card">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <h5 style="margin:0; color:#1a1a2e;"><?php echo htmlspecialchars($complaint['subject']); ?></h5>
                                    <span class="badge-priority priority-<?php echo $complaint['priority']; ?>">
                                        <?php echo ucfirst($complaint['priority']); ?>
                                    </span>
                                </div>
                                <p class="text-muted mb-2" style="font-size: 13px;">
                                    <i class="fas fa-tag"></i> <?php echo htmlspecialchars($complaint['category']); ?> | 
                                    <i class="fas fa-clock"></i> <?php echo date('M d, Y', strtotime($complaint['created_at'])); ?>
                                </p>
                                <p style="font-size: 14px; color: #555;"><?php echo nl2br(htmlspecialchars(substr($complaint['description'], 0, 100))); ?>...</p>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="status-<?php echo $complaint['status']; ?>">
                                        <i class="fas fa-circle" style="font-size: 8px;"></i> 
                                        <?php echo ucfirst(str_replace('_', ' ', $complaint['status'])); ?>
                                    </span>
                                    <?php if ($complaint['response']): ?>
                                        <small class="text-success"><i class="fas fa-reply"></i> Response received</small>
                                    <?php endif; ?>
                                </div>
                                <?php if ($complaint['response']): ?>
                                    <div style="background: #f5f5f5; padding: 10px; border-radius: 8px; margin-top: 10px;">
                                        <strong style="color: #7c3aed;">Response:</strong><br>
                                        <span style="font-size: 13px;"><?php echo nl2br(htmlspecialchars($complaint['response'])); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <footer style="background: #1a1a2e; padding: 30px 0; margin-top: 50px;">
        <div class="container text-center">
            <a class="navbar-brand" href="#" style="color: #00d4ff;">Hostel<span class="display"> Management</span></a>
            <p style="color: rgba(255,255,255,0.6); margin-top: 15px;">&copy; 2025 Hostel Management System. All Rights Reserved | Developed by Student Developer</p>
        </div>
    </footer>

    <script src="web_home/js/jquery-2.2.3.min.js"></script>
    <script src="web_home/js/bootstrap.js"></script>
</body>
</html>
